#!/bin/bash
#SBATCH --time=20:00:00
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=10
#SBATCH --mem=400000

#alignment_summary.sh
#This step is useful in detailing the quality of the read alignments and the proportion of the machine signal-to-noise threshold quality filters. It is to be noted that these quality filters are specific to Illumina data.


#Load variables
. variables

#define variables
ref=/scratch/cmp1g20/ref_genome/hg38.fa

#load modules
module load conda
source activate py3venv
module load picard

#collect alignment and insert size metrics
picard CollectInsertSizeMetrics I="$sampleID"_Aligned.sortedByCoord.out.bam O=/scratch/cmp1g20/RMS_resistance_data/ZOES_DATA/INSERT_METRICS/"$sampleID"_insert_size_metrics.txt  H=/scratch/cmp1g20/RMS_resistance_data/ZOES_DATA/INSERT_SIZE_HISTOGRAMS/"$sampleID"_insert_size_histogram.pdf

conda deactivate
